<!DOCTYPE html>
<html lang="en">


<head>

  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="">
  <meta name="author" content="">

  <title>National Quiz Competition</title>

  <!-- Bootstrap core CSS -->
  <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">

  <!-- Custom styles for this template -->
  <link href="css/style.css" rel="stylesheet">

  <!-- animation stylesheet -->
  <link href="css/animate.css" rel="stylesheet">

  <!-- Fontawesome stylesheet -->
  <link rel="stylesheet" href="font-awesome/css/font-awesome.min.css">

</head>

<body class="light-bg home-bg">

  <!-- Navigation -->
  <nav class="navbar navbar-expand-lg">
  	<div class="container">
  		<a href="schools.php" class="h1"><i class="fa fa-angle-left color-dark"></i></a>
      <h5 class="text-white text-center mx-auto"><b>Leaderboard</b></h5>
      <button class="gradientBtn animated wow fadeInUp delay-0-3s">
                <?php include("rounds-selector.php");?>
      </button>
    </div>
  </nav>

  <!-- Page Content -->

    <div class="container mt-4 col-md-6">

      <?php
          //LOAD SCHOOL
          include("connection-string.php");
          
            $sql0 = "SELECT DISTINCT s.id, s.school_id, s.school_name, s.school_logo FROM total_scores sc INNER JOIN schools s ON sc.school_id = s.school_id WHERE sc.status = 'publish'";
          
          $res0 = mysqli_query($connect, $sql0);
          if($res0)
          {
              while($row = mysqli_fetch_array($res0,MYSQLI_ASSOC))
              {
                 $id = $row["id"];
                 $school_id = $row["school_id"];
                 $school_name = $row["school_name"];
                 $school_logo = $row["school_logo"];

                 echo '<div class="square mt-4">
                 <center><span class="rounded-circle bg-teal text-white badge position-relative z-Index-2 animated wow bounce delay-0-4s">'.$id.'</span>
                 <span class="topperSquare zIndex-1 mb-4 animated wow zoomIn"><span class="topperInner bg-purple"><img src="images/leaderboard/teacher.png" class="rotate-45 rounded-circle" /></span></span>
                 <h6 class="color-dark text-center animated wow slideInUp font-weight-bold">'.$school_name.'</h6>
                </div>';


              }
          }


      ?>
    </div>
    
    <div class="container">
      <div class="col-auto col-centered leaderboard table-responsive">
        <table class="table">
          <tbody>
            <?php
            
                /*--- CHOOSE SCORING SYSTEM TO KNOW WHAT TO SHOW---------*/
                $sqlSettings = "SELECT * FROM settings WHERE round_id IN (1,2,3)";
                $resSettings = mysqli_query($connect, $sqlSettings);
                if($resSettings)
                {
                    while($rowSettings = mysqli_fetch_array($resSettings,MYSQLI_ASSOC))
                    {
                        $scoring_system = $rowSettings['scoring_system'];
                    }
                }
                
                if($scoring_system == "cumulative")
                {
                
                  
                    $sql1 = "SELECT s.id AS id, s.school_name, s.school_id, s.status, sc.score AS total_points, sc.round_id As result_round
                     FROM total_scores sc
                     INNER JOIN schools s ON sc.school_id = s.school_id
                     WHERE sc.status = 'publish'
                     GROUP BY sc.school_id";
    
                    
                  $res1 = mysqli_query($connect, $sql1);
                  if($res1)
                  {
                      $count_disqualify_school = 0;
                      while($row1 = mysqli_fetch_array($res1,MYSQLI_ASSOC))
                      {
                        $id = $row1["id"];
                        $school_id = $row1["school_id"];
                        $total_points = $row1["total_points"];
                        $result_round = $row1['result_round'];
                        $school_name = $row1["school_name"];
                        $status = $row1["status"];
                        
                        if($status == 'blocked')
                        {
                            $img = "images/disqualify.png";
                            $count_disqualify_school = $count_disqualify_school + 1;
                        }else{
                            
                             $img = "images/leaderboard/trophy.png";
                        }
                        
                        if($school_id == 1006)
                        {
                            $avatar = "images/leaderboard/female.png";
                        }else{
                            $avatar = "images/leaderboard/teacher.png";
                        }
    
                       echo '<tr class="shadow bg-white animated wow fadeInDown delay-0-3s">
                          <th scope="row" class="color-blue">'.$id.'</th>
                           <th scope="row" class="color-blue">Round '.$result_round.'</th>
                          <td><img src="'.$avatar.'" class="rounded-circle bg-green ranker-profile"></td>
                          <td><h6 class="text-dark">'.$school_name.'</h6></td>
                          <td><h5 class="color-purple"><b>'.$total_points.'</b></h5></td>
                          <td><img src="'.$img.'" /></td>
                        </tr>';
                      
    
                      }
                      
                      if($count_disqualify_school == 0)
                      {
                          echo "<br/>";
                           echo '<tr class="shadow bg-white animated wow fadeInDown delay-0-3s">
                           <a href="random-quiz-participant.php" class="gradientBtn animated wow fadeInUp delay-0-3s">
                                No schools have been disqualified due to the same points.
                                Click here proceed to the Random quiz!
                                </a>
                        </tr>';
                      }
                  }
                  
                  //Cummulative table
                  $sqlCum = "SELECT
                            s.school_name AS `School Name`, s.id AS `School ID`,s.status AS `Quiz Status`,
                            COALESCE(SUM(CASE WHEN sc.round_id = 1 THEN sc.score ELSE 0 END), 0) AS `Cum Score Round 1`,
                            COALESCE(SUM(CASE WHEN sc.round_id = 2 THEN sc.score ELSE 0 END), 0) AS `Cum Score Round 2`,
                            COALESCE(SUM(CASE WHEN sc.round_id = 3 THEN sc.score ELSE 0 END), 0) AS `Cum Score Round 3`,
                            COALESCE(SUM(CASE WHEN sc.round_id IN (1, 2, 3) THEN sc.score ELSE 0 END), 0) AS `Overall Score`
                        FROM
                            total_scores sc
                        INNER JOIN
                            schools s ON sc.school_id = s.school_id
                        GROUP BY
                            s.school_name";
                      
                      
                     /*$sqlCum = "SELECT
                                s.school_name AS `School Name`,
                                s.id AS `School ID`,
                                CASE
                                    WHEN COALESCE(SUM(CASE WHEN sc.round_id = 1 THEN sc.score ELSE 0 END), 0) = 0 THEN '_'
                                    ELSE COALESCE(SUM(CASE WHEN sc.round_id = 1 THEN sc.score ELSE 0 END), 0)
                                END AS `Cum Score Round 1`,
                                CASE
                                    WHEN COALESCE(SUM(CASE WHEN sc.round_id = 2 THEN sc.score ELSE 0 END), 0) = 0 THEN '_'
                                    ELSE COALESCE(SUM(CASE WHEN sc.round_id = 2 THEN sc.score ELSE 0 END), 0)
                                END AS `Cum Score Round 2`,
                                CASE
                                    WHEN COALESCE(SUM(CASE WHEN sc.round_id = 3 THEN sc.score ELSE 0 END), 0) = 0 THEN '_'
                                    ELSE COALESCE(SUM(CASE WHEN sc.round_id = 3 THEN sc.score ELSE 0 END), 0)
                                END AS `Cum Score Round 3`,
                                CASE
                                    WHEN COALESCE(SUM(CASE WHEN sc.round_id IN (1, 2, 3) THEN sc.score ELSE 0 END), 0) = 0 THEN '_'
                                    ELSE COALESCE(SUM(CASE WHEN sc.round_id IN (1, 2, 3) THEN sc.score ELSE 0 END), 0)
                                END AS `Overall Score`
                            FROM
                                total_scores sc
                            INNER JOIN
                                schools s ON sc.school_id = s.school_id
                            GROUP BY
                                s.school_name, s.id"; */    
                   
                            
                  $resCum = mysqli_query($connect, $sqlCum);
                  if($resCum)
                  {
                       echo "<tr class=\"shadow bg-dark text-white animated wow fadeInDown delay-0-3s\">
                                 
                                <td> School Name</td>
                                <td> Score for Round 1</td>
                                <td> Score for Round 2</td>
                                <td> Score for Round 3</td>
                                <td> Cumulative Score</td>
                                <td> Result</td>
                              </tr>";
                     
                      while($rowCum = mysqli_fetch_array($resCum,MYSQLI_ASSOC))
                      {
                          
                           echo "<tr class=\"shadow bg-dark text-white animated wow fadeInDown delay-0-3s\">
                                <td>" . htmlspecialchars($rowCum["School Name"]) . "</td>
                                <td>" . htmlspecialchars($rowCum["Cum Score Round 1"]) . "</td>
                                <td>" . htmlspecialchars($rowCum["Cum Score Round 2"]) . "</td>
                                <td>" . htmlspecialchars($rowCum["Cum Score Round 3"]) . "</td>
                                <td>" . htmlspecialchars($rowCum["Overall Score"]) . "</td>
                               <td>" . htmlspecialchars($rowCum["Quiz Status"] === 'blocked' ? 'DISQUALIFIED' : $rowCum["Quiz Status"]) . "</td>

                                
                              </tr>";
                          
                          
                      }
                      
                      
                  }
                  
                }
                else
                {
                    
                         $sql1 = "SELECT s.id AS id, s.school_name, s.school_id, s.status, sc.score AS total_points, sc.round_id As result_round
                         FROM total_scores sc
                         INNER JOIN schools s ON sc.school_id = s.school_id
                         WHERE sc.status = 'publish'
                         GROUP BY sc.school_id";
    
                    
                      $res1 = mysqli_query($connect, $sql1);
                      if($res1)
                      {
                          $count_disqualify_school = 0;
                          while($row1 = mysqli_fetch_array($res1,MYSQLI_ASSOC))
                          {
                            $id = $row1["id"];
                            $school_id = $row1["school_id"];
                            $total_points = $row1["total_points"];
                            $result_round = $row1['result_round'];
                            $school_name = $row1["school_name"];
                            $status = $row1["status"];
                            
                            if($status == 'blocked')
                            {
                                $img = "images/disqualify.png";
                                $count_disqualify_school = $count_disqualify_school + 1;
                            }else{
                                
                                 $img = "images/leaderboard/trophy.png";
                            }
                            
                            if($school_id == 1006)
                            {
                                $avatar = "images/leaderboard/female.png";
                            }else{
                                $avatar = "images/leaderboard/teacher.png";
                            }
        
                           echo '<tr class="shadow bg-white animated wow fadeInDown delay-0-3s">
                              <th scope="row" class="color-blue">'.$id.'</th>
                               <th scope="row" class="color-blue">Round '.$result_round.'</th>
                              <td><img src="'.$avatar.'" class="rounded-circle bg-green ranker-profile"></td>
                              <td><h6 class="text-dark">'.$school_name.'</h6></td>
                              <td><h5 class="color-purple"><b>'.$total_points.'</b></h5></td>
                              <td><img src="'.$img.'" /></td>
                            </tr>';
                          
        
                          }
                          
                          if($count_disqualify_school == 0)
                          {
                              echo "<br/>";
                               echo '<tr class="shadow bg-white animated wow fadeInDown delay-0-3s">
                               <a href="random-quiz-participant.php" class="gradientBtn animated wow fadeInUp delay-0-3s">
                                    No schools have been disqualified due to the same points.
                                    Click here proceed to the Random quiz!
                                    </a>
                            </tr>';
                          }
                      }
                    
                    
                }
            
            ?>
          </tbody>    
        </table>  
      </div>  
    </div>

        <!-- Bootstrap core JavaScript -->
        <script src="vendor/jquery/jquery.min.js"></script>
        <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
		<!-- 
right click off -->
<script type="text/javascript">
    document.addEventListener('contextmenu', event => event.preventDefault());
</script>
  </body>


</html>
