<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>MILLIONAIRE QUIZ COMPETITION</title>

    <!-- Bootstrap core CSS -->
    <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">

    <!-- Custom styles for this template -->
    <link href="css/style.css" rel="stylesheet">

    <!-- animation stylesheet -->
    <link href="css/animate.css" rel="stylesheet">

    <!-- Fontawesome stylesheet -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding-bottom: 80px;
        }

        /* Navigation Styles */
        .navbar {
            background: linear-gradient(90deg, #1e3c72 0%, #2a5298 100%);
            padding: 1.2rem 0;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .navbar .back-btn {
            color: white;
            font-size: 1.5rem;
            text-decoration: none;
            transition: transform 0.3s ease;
        }

        .navbar .back-btn:hover {
            transform: translateX(-5px);
        }

        .navbar h5 {
            color: white;
            font-weight: 600;
            letter-spacing: 1px;
            margin: 0;
        }

        /* Main Container */
        .main-container {
            max-width: 1200px;
            margin: 2rem auto;
            padding: 0 15px;
        }

        /* Header Card */
        .header-card {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
            text-align: center;
        }

        .header-card h2 {
            color: #1e3c72;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .header-card p {
            color: #6c757d;
            margin: 0;
        }

        /* Table Container */
        .table-container {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        }

        /* Table Styles */
        .custom-table {
            width: 100%;
            margin: 0;
            border-collapse: separate;
            border-spacing: 0;
        }

        .custom-table thead {
            background: linear-gradient(90deg, #1e3c72 0%, #2a5298 100%);
        }

        .custom-table thead th {
            color: white;
            font-weight: 600;
            padding: 1rem;
            text-align: left;
            border: none;
            font-size: 0.95rem;
            letter-spacing: 0.5px;
        }

        .custom-table thead th:first-child {
            border-top-left-radius: 10px;
        }

        .custom-table thead th:last-child {
            border-top-right-radius: 10px;
        }

        .custom-table tbody tr {
            transition: all 0.3s ease;
            border-bottom: 1px solid #e9ecef;
        }

        .custom-table tbody tr:hover {
            background-color: #f8f9ff;
            transform: scale(1.01);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.05);
        }

        .custom-table tbody td {
            padding: 1.2rem 1rem;
            vertical-align: middle;
        }

        .school-logo {
            width: 70px;
            height: 70px;
            object-fit: cover;
            border-radius: 50%;
            border: 3px solid #2a5298;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .school-name {
            font-weight: 600;
            color: #2c3e50;
            font-size: 1.1rem;
        }

        .select-btn {
            background: linear-gradient(90deg, #28a745 0%, #20c997 100%);
            color: white;
            border: none;
            padding: 0.6rem 2rem;
            border-radius: 25px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            box-shadow: 0 4px 10px rgba(40, 167, 69, 0.3);
        }

        .select-btn:hover {
            background: linear-gradient(90deg, #20c997 0%, #28a745 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(40, 167, 69, 0.4);
            color: white;
        }

        /* No Data Message */
        .no-data {
            text-align: center;
            padding: 3rem;
            color: #6c757d;
        }

        .no-data i {
            font-size: 4rem;
            color: #cbd5e0;
            margin-bottom: 1rem;
        }

        .no-data h4 {
            color: #2c3e50;
            margin-bottom: 0.5rem;
        }

        /* Footer */
        .custom-footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            background: linear-gradient(90deg, #1e3c72 0%, #2a5298 100%);
            padding: 1rem 0;
            box-shadow: 0 -4px 6px rgba(0, 0, 0, 0.1);
        }

        .custom-footer p {
            color: white;
            margin: 0;
            text-align: center;
            font-size: 0.9rem;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .header-card {
                padding: 1.5rem;
            }

            .table-container {
                padding: 1rem;
                overflow-x: auto;
            }

            .custom-table {
                font-size: 0.9rem;
            }

            .school-logo {
                width: 50px;
                height: 50px;
            }

            .school-name {
                font-size: 1rem;
            }

            .select-btn {
                padding: 0.5rem 1.5rem;
                font-size: 0.9rem;
            }
        }
    </style>
</head>

<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="container">
            <a href="index.php" class="back-btn"><i class="fas fa-arrow-left"></i></a>
            <h5><i class="fas fa-school"></i> PARTICIPATING SCHOOLS</h5>
            <?php include("view-result.php"); ?>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="main-container">
        <!-- Header Card -->
        <div class="header-card">
            <h2><i class="fas fa-trophy"></i> Select Your School</h2>
            <p>Choose a school to begin the Millionaire Quiz Competition</p>
        </div>

        <!-- Table Container -->
        <div class="table-container">
            <?php
                $host = "localhost";
                $username = "root";
                $password = "";
                $database = "quiz";

                // Create a database connection
                $connection = new mysqli($host, $username, $password, $database);

                // Check the connection
                if ($connection->connect_error) {
                    die("Connection failed: " . $connection->connect_error);
                }

                // SQL query to retrieve schools with an active status
                $sql = "SELECT school_id, school_name, school_logo FROM schools WHERE status = 'Active'";
                $result = $connection->query($sql);

                if ($result->num_rows > 0) {
                    echo '<table class="custom-table">';
                    echo '<thead>';
                    echo '<tr>';
                    echo '<th><i class="fas fa-image"></i> Logo</th>';
                    echo '<th><i class="fas fa-graduation-cap"></i> School Name</th>';
                    echo '<th><i class="fas fa-hand-pointer"></i> Action</th>';
                    echo '</tr>';
                    echo '</thead>';
                    echo '<tbody>';

                    while ($row = $result->fetch_assoc()) {
                        echo '<tr>';
                        echo '<td><img src="' . $row["school_logo"] . '" class="school-logo" alt="School Logo"></td>';
                        echo '<td class="school-name">' . $row["school_name"] . '</td>';
                        echo '<td><a href="question-selector.php?school_id=' . $row["school_id"] . '" class="select-btn"><i class="fas fa-check-circle"></i> Select</a></td>';
                        echo '</tr>';
                    }

                    echo '</tbody>';
                    echo '</table>';
                } else {
                    echo '<div class="no-data">';
                    echo '<i class="fas fa-inbox"></i>';
                    echo '<h4>No Active Schools Found</h4>';
                    echo '<p>There are currently no schools available for the competition.</p>';
                    echo '</div>';
                }

                // Close the database connection
                $connection->close();
            ?>
        </div>
    </div>

    <!-- Footer -->
    <footer class="custom-footer">
        <p><i class="fas fa-copyright"></i> NATIONAL QUIZ COMPETITION - All Rights Reserved</p>
    </footer>

    <!-- Bootstrap core JavaScript -->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- single selectable category -->
    <script type="text/javascript">
        $('input[type="checkbox"]').on('change', function() {
            $('input[type="checkbox"]').not(this).prop('checked', false);
        });
    </script>

    <!-- right click off -->
    <script type="text/javascript">
        document.addEventListener('contextmenu', event => event.preventDefault());
    </script>
</body>

</html>