<?php

try {
    // Replace with your database connection details
    $pdo = new PDO('mysql:host=localhost;dbname=queasses_quiz', 'queasses_quiz', 'Jabulani009$');
    
    // Set the PDO error mode to exception
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $roundId = $selected_round_id;
    // Your SQL query
    $sql = "SELECT GROUP_CONCAT(CONCAT(school_id, ':', score) ORDER BY score ASC) AS smallest_scores
            FROM (
                SELECT score, school_id
                FROM total_scores
                WHERE round_id = :round_id
                ORDER BY score ASC
                LIMIT 1
            ) AS subquery";

    // Prepare the SQL statement
    $stmt = $pdo->prepare($sql);
    
    // Bind the round_id parameter
    $stmt->bindParam(':round_id', $roundId, PDO::PARAM_INT);

    // Execute the query
    $stmt->execute();

    // Fetch the result
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    // Output the result
    //echo "Smallest Scores: " . $result['smallest_scores'];
    
    // Extract the numbers before ':' and update the schools table
    $scores = explode(',', $result['smallest_scores']);
    foreach ($scores as $score) {
        list($schoolId, $scoreValue) = explode(':', $score);
        
        // Update the schools table
        $updateSql = "UPDATE schools SET status = 'blocked' WHERE school_id = :school_id";
        $updateStmt = $pdo->prepare($updateSql);
        $updateStmt->bindParam(':school_id', $schoolId, PDO::PARAM_INT);
        $updateStmt->execute();
    }
    
   

} catch (PDOException $e) {
    // Handle database connection errors
   // echo "Error: " . $e->getMessage();
}
?>

