<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add New School</title>
    <!-- Include Bootstrap CSS -->
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="card shadow">
                    <div class="card-header">
                        <h5>Add New School</h5>
                    </div>
                    <div class="card-body">
                        <form action="controller.php" method="post" enctype="multipart/form-data">
                            <div class="form-group">
                                <label for="school_id">School ID:</label>
                                <input type="text" class="form-control" id="school_id" name="school_id" required>
                            </div>
                            <div class="form-group">
                                <label for="school_name">School Name:</label>
                                <input type="text" class="form-control" id="school_name" name="school_name" required>
                            </div>
                            <div class="form-group">
                                <label for="school_logo">School Logo:</label>
                                <input type="file" class="form-control-file" id="school_logo" name="school_logo" required>
                            </div>
                            <div class="form-group">
                                <label for="status">Status:</label>
                                <select class="form-control" id="status" name="status" required>
                                    <option value="active">active</option>
                                    <option value="blocked">blocked</option>
                                </select>
                            </div>
                            <button type="submit" name="add_school" class="btn btn-primary">Add School</button>
                        </form>
                        <a href="portal.php" class="btn btn-secondary mt-3">Back to Portal</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Include Bootstrap JS and Popper.js -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
