<?php
// Database connection details
$servername = "localhost";
$username = "queasses_quiz";
$password = "Jabulani009$";
$database = "queasses_quiz";

// Create a connection to the database
$conn = new mysqli($servername, $username, $password, $database);

// Check the connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Check if a CSV file was uploaded
    if (isset($_FILES["csv_file"]) && $_FILES["csv_file"]["error"] == UPLOAD_ERR_OK) {
        $csv_file = $_FILES["csv_file"]["tmp_name"];

        // Open and read the CSV file
        if (($handle = fopen($csv_file, "r")) !== false) {
            while (($data = fgetcsv($handle, 1000, ",")) !== false) {
                $question_id = $data[0];
                $option1 = $data[1];
                $option2 = $data[2];
                $option3 = $data[3];
                $option4 = $data[4];
                $answer = $data[5];
                $is_multiple_choice = $data[6];
                
              
                // Insert data into the "question" table
                $sql = "INSERT INTO answers (question_id,option1,option2,option3,option4,answer,is_multiple_choice) VALUES (?, ?, ?, ?, ?, ?, ?)";
                $stmt = $conn->prepare($sql);

                if ($stmt) {
                    $stmt->bind_param("issssss", $question_id, $option1, $option2, $option3, $option4, $answer, $is_multiple_choice);
                    if (!$stmt->execute()) {
                        echo "Error inserting data: " . $stmt->error;
                    }
                    $stmt->close();
                } else {
                    echo "Error preparing statement: " . $conn->error;
                }
            }
            fclose($handle);

            echo "Data uploaded successfully!";
        } else {
            echo "Error reading the CSV file.";
        }
    } else {
        echo "Please upload a valid CSV file.";
    }
}

// Close the database connection
$conn->close();
?>
